<?php
include_once "../include/site.config.php";


$userTo = array();
$userTo['email'] 		= $_POST['email'] ? $_POST['email'] : null;
$userTo['password'] 	= sha1(strTrim($_POST['password']));
$userTo['name'] 		= strTrim($_POST['name']);
$userTo['team'] 		= strTrim($_POST['team']);
$userTo['contact_phone'] 		= strTrim($_POST['contact_phone']);
$userTo['mobile'] 		= strTrim($_POST['mobile']);

$userTo['email_auth']	= "N";
$userTo['email_auth_code']	= create_email_auth_key();



$companyTo = array();
$companyTo['company_name'] 		= $_POST['company_name'] ? $_POST['company_name'] : null;
$companyTo['domain'] 				= $_POST['domain'] ? $_POST['domain'] : null;
$companyTo['company_phone'] 		= $_POST['company_phone'] ? $_POST['company_phone'] : null;
$companyTo['company_biz_number'] 		= $_POST['company_biz_number'] ? $_POST['company_biz_number'] : null;



// 빈값 확인...
foreach($userTo as $k=>$v){
	if(!$v){
		goBack("잘못된 접근입니다.");
	}
}

foreach($companyTo as $k=>$v){
	if(!$v){
		goBack("잘못된 접근입니다.");
	}
}



// pdo ready
$userTo_Keys = array_keys($userTo);
$member_insertDatas = array();

$keys = join(',', $userTo_Keys);
ATA($userTo, $keys, $member_insertDatas, true);


$stmt = $PDO->prepare('INSERT INTO member set reg_date=now(), '.bindFields($member_insertDatas));
$result = $stmt->execute($member_insertDatas);


if (!$result) {
	goBack("등록에 문제가 생겼습니다. 관리자에게 문의해주세요.");
}



$member_idx = $PDO->lastInsertId();  // 회원고유번호





/* 회사코드 생성 - 중복 확인 */
$company_code = randomKey(8);

$check_stmt = $PDO->prepare('SELECT * FROM company WHERE  company_code = ?');
$check_stmt->execute([$company_code]);

if($check_stmt->rowCount()){
	while(1){
		$company_code = randomKey(8);
		
		$check_stmt = $PDO->prepare('SELECT * FROM company WHERE  company_code = ?');
		$check_stmt->execute([$company_code]);
		if(!$check_stmt->rowCount()){
			break;
		}
	}
}
/* /회사코드 생성 - 중복 확인 */





/*
 * 회사정보 기록
 */
$companyTo['reg_member_idx'] = $member_idx;
$companyTo['company_code'] = $company_code;



// pdo ready
$companyTo_Keys = array_keys($companyTo);
$insertDatas = array();

$keys = join(',', $companyTo_Keys);
ATA($companyTo, $keys, $insertDatas, true);


$stmt = $PDO->prepare('INSERT INTO company set reg_date=now(), '.bindFields($insertDatas));
$result = $stmt->execute($insertDatas);



if (!$result) {
	echo "<script>alert('".$result."');</script>";
	//goBack("등록에 문제가 생겼습니다. 관리자에게 문의해주세요.");
}else{

	
	
	$company_idx = $PDO->lastInsertId();  // 회사 고유번호 

	$rsa = rsa_generate_keys($company_idx);
		

	$stmt = $PDO->prepare('UPDATE company set private_key = ? where company_idx = ?');
	$stmt->execute([$rsa[private_key], $company_idx]);
	
	$stmt = $PDO->prepare('UPDATE company set public_key = ? where company_idx = ?');
	$stmt->execute([$rsa[public_key], $company_idx]);
		
	// 회원정보에 회사 아이디 매칭
	$stmt = $PDO->prepare('UPDATE member set company_idx = ? where member_idx = ?');
	$stmt->execute([$company_idx, $member_idx]);
	
	
	
	// 인증메일 발송
	$auth_content = "[{company} {domain}]의 인증 시스템가입을 위해  아래 인증번호를 가입페이지에서 입력하세요.<br/>
					이메일인증확인 번호 : <a href='http://admin.msaber.io/email_auth/?code={auth_code}'>{auth_code}</a>
					";
	$auth_content = str_replace("{company}", $companyTo['company_name'], $auth_content);
	$auth_content = str_replace("{domain}", $companyTo['domain'], $auth_content);
	$auth_content = str_replace("{auth_code}", $userTo['email_auth_code'], $auth_content);
	
	sendmail($userTo['email'],
			"[M세이버] 회원가입 이메일 확인 메일입니다.",
			$auth_content
			);
	
	goHref("/?pn=login", "가입이 완료되었습니다. 인증 메일 확인 후 이용해주세요.");
}





























