<?php


//SMS 전송 function
// - 2012. 10. 26 Seung.Kim
// $type 없으면 MMS L 이면 LMS
function sendSMS($phoneNo, $msg, $timeset = null, $type = ""){

	$sms_url = "http://sslsms.cafe24.com/sms_sender.php"; // 전송요청 URL
	// $sms_url = "https://sslsms.cafe24.com/sms_sender.php"; // HTTPS 전송요청 URL
	$sms['user_id'] = base64_encode("serobmobile"); //SMS 아이디.
	$sms['secure'] = base64_encode("af5922a099bb1e47543ba5e2ff3c017d") ;//인증키
	$sms['msg'] = base64_encode($msg);

	$sms['rphone'] = base64_encode($phoneNo);
	$sms['sphone1'] = base64_encode("02");
	$sms['sphone2'] = base64_encode("6929");
	$sms['sphone3'] = base64_encode("0508");

	if(isset($type) && $type == "L"){
		$sms['smsType'] = base64_encode("L");
	}
	$sms['mode'] = base64_encode("1"); // base64 사용시 반드시 모드값을 1로 주셔야 합니다.


	if(is_array($timeset)){
		if(count($timeset) == 2){
			$sms['rdate'] = base64_encode($timeset[0]);
			$sms['rtime'] = base64_encode($timeset[1]);
		}
	}


	$host_info = explode("/", $sms_url);
	$host = $host_info[2];
	$path = "/".$host_info[3];

	srand((double)microtime()*1000000);
	$boundary = "---------------------".substr(md5(rand(0,32000)),0,10);
	//print_r($sms);

	// 헤더 생성
	$header = "POST /".$path ." HTTP/1.0\r\n";
	$header .= "Host: ".$host."\r\n";
	$header .= "Content-type: multipart/form-data, boundary=".$boundary."\r\n";

	// 본문 생성
	$data = "";
	foreach($sms AS $index => $value){
		$data .="--$boundary\r\n";
		$data .= "Content-Disposition: form-data; name=\"".$index."\"\r\n";
		$data .= "\r\n".$value."\r\n";
		$data .="--$boundary\r\n";
	}
	$header .= "Content-length: " . strlen($data) . "\r\n\r\n";

	$fp = fsockopen($host, 80);

	if ($fp) {
		fputs($fp, $header.$data);
		$rsp = '';
		while(!feof($fp)) {
			$rsp .= fgets($fp,8192);
		}
		fclose($fp);
		$msg = explode("\r\n\r\n",trim($rsp));
		$rMsg = explode(",", $msg[1]);


	}
}



/*
 설명 : 문자열 공백 제거 및 태그 제거
 */
function strTrim($str,$len=false,$tags=false){
	//$str = trim($str);
	if ($tags) $str = htmlspecialchars($str);
	if ($len) $str = strHanCut($str,$len,false);
	return $str;
}

/*
 설명 : 문자열 $len 만큼 자르기
 */
function strHanCut($str,$len,$point=true,$charset="UTF-8")
{
	if ($len >= strlen($str)) {
		return $str;
	} else {

		$str = substr($str,0,$len);
		$han_char = 0;
		for ($i=$len-1;$i>=0;$i--){
			$last_char = ord(substr($str,$i,1)); //->아스키코드값으로 변환
			if (127 > $last_char){
				break;
			}else{
				$han_char++;
			}
		}

		if (strtoupper($charset) != 'UTF-8') {
			if ($han_char%2==1){
				$str = substr($str,0,$len-1);
			}
		}

		if ($point){
			return $str."...";
		}else{
			return $str;
		}
	}
}


function ATA($source = array(), $keys = '', &$target = array(), $emptyValue = true){
	$keys = preg_replace('/\s+/', '', $keys);
	$require_key = explode(',', $keys);

	if(count($require_key)){
		foreach($require_key as $k){
			if(isset($source[$k]) && $source[$k] != ''){
				$target[$k] = $source[$k];
			}else{
				if($emptyValue){
					$target[$k] = "";
				}
			}
		}

	}else{
		$target = array();
	}

	return;
}
/**
 * bind
 *
 * @param {array} $url
 * @return array
 * @exception
 */
function bindFields($fields){
	end($fields); $lastField = key($fields);
	$bindString = ' ';
	foreach($fields as $field => $data){
		$bindString .= $field . '="' . $data.'"';
		$bindString .= ($field === $lastField ? ' ' : ',');
	}
	return $bindString;
}




/**
 * URL 이동
 *
 * @param {string} $url 
 * @param optional {string} $msg 
 * @return null
 * @exception
 */
function GoHref($url = '', $msg = NULL){
	ob_clean();

	if($url){
		if($msg){
			echo "<script>alert('".addslashes($msg)."');</script>";
			echo "<script>window.location.href= '".$url."' ;</script>";
		}else{
			header('location:'.$url);
		}
	}
	exit;
}

/**
 * 뒤로가기
 *
 * @param optional {string} $msg
 * @return null
 * @exception
 */
function GoBack($msg = NULL){
	
	//ob_clean();

	if($msg){
		echo "<script>alert('".addslashes($msg)."');</script>";
		echo "<script>history.back();</script>";
	}else{
		echo "<script>history.back();</script>";
	}

	exit;
}


function parent_reload($msg = NULL){
	ob_clean();

	if($msg){
		echo "<script>alert('".addslashes($msg)."');</script>";
		echo "<script>parent.location.reload();</script>";
	}else{
		echo "<script>parent.location.reload();</script>";
	}

	exit;
}

function parent_alert($msg = NULL){
	ob_clean();

	if($msg){
		echo "<script>alert('".addslashes($msg)."');</script>";
		
	}else{
		
	}

	exit;
}




function getTeamInfo($team_idx = null, $isApp = false){
	global $PDO;
	
	$stmt = $PDO->prepare('SELECT * FROM team_category WHERE team_idx = ?');
	$stmt->execute([$team_idx]);
	
	$appReturn = array();
	$appReturn[0] = $appReturn[1] = $appReturn[2] = ""; 
	
	
	
	$_info = null;
	if($_info = $stmt->fetch(PDO::FETCH_OBJ)){
		
		if($_info->depth == 1){
			
			if($isApp){
				$appReturn[0] =$_info->team_name;
				return array_values(array_filter($appReturn));  
			}else{
				return $_info->team_name;
			}
			
			 
		}else{
			if($_info->depth == 2){
				
				$stmt = $PDO->prepare('SELECT * FROM team_category WHERE depth=1 and team_idx = ?');
				$stmt->execute([$_info->parent_node]);
				
				$_info_p1 = $stmt->fetch(PDO::FETCH_OBJ);
				
				$ret_str = $_info_p1->team_name." > ".$_info->team_name;
				
				
				if($isApp){
					$appReturn[0] = $_info_p1->team_name;
					$appReturn[1] = $_info->team_name;
				}
				
			}else if($_info->depth == 3){
				
				$stmt = $PDO->prepare('SELECT * FROM team_category WHERE depth=2 and team_idx = ?');
				$stmt->execute([$_info->parent_node]);
				
				$_info_p2 = $stmt->fetch(PDO::FETCH_OBJ);
				
				$stmt = $PDO->prepare('SELECT * FROM team_category WHERE depth=1 and team_idx = ?');
				$stmt->execute([$_info_p2->parent_node]);
				
				$_info_p3 = $stmt->fetch(PDO::FETCH_OBJ);
				
				
				
				$ret_str = $_info_p3->team_name." > ".$_info_p2->team_name." > ".$_info->team_name;
				
				if($isApp){
					$appReturn[0] = $_info_p3->team_name;
					$appReturn[1] = $_info_p2->team_name;
					$appReturn[2] = $_info->team_name;
				}
				
				
				
			}
			
			if($isApp){
				return array_values(array_filter($appReturn));
			}else{
				return $ret_str;
			}
			
			
		}
		
	}
	return null;
}





function getCompany_info($company_idx = null){
	global $PDO;
	$stmt = $PDO->prepare('SELECT * FROM company WHERE company_idx = ?');
	$stmt->execute([$company_idx]);
	
	$user_info = null;
	if($stmt->rowCount()){
		$com_info = $stmt->fetch(PDO::FETCH_OBJ);
		return $com_info;
	}
	return null;
	
}



function getCompany_siteName($company_code = null){
	global $PDO;
	$stmt = $PDO->prepare('SELECT * FROM domain_bridge WHERE company_code = ?');
	$stmt->execute([$company_code]);

	$user_info = null;
	if($stmt->rowCount()){
		$com_info = $stmt->fetch(PDO::FETCH_OBJ);
		return $com_info;
	}
	return null;

}


// 직원 정보 획득 - idx로 가져옴
function getUserData_appMember($mem_idx = null){
	global $PDO;
	$stmt = $PDO->prepare('SELECT * FROM tb_site_user WHERE i_idx = ?');
	$stmt->execute([$mem_idx]);

	$user_info = null;
	if($stmt->rowCount()){
		$user_info = $stmt->fetch(PDO::FETCH_OBJ);
		return $user_info;
	}
	return null;
}



// 사용자 정보 획득 - idx로 가져옴
function getUserData_withoutSession($mem_idx = null){
	global $PDO;
	$stmt = $PDO->prepare('SELECT * FROM member WHERE member_idx = ?');
	$stmt->execute([$mem_idx]);

	$user_info = null;
	if($stmt->rowCount()){
		$user_info = $stmt->fetch(PDO::FETCH_OBJ);
		return $user_info;
	}
	return null;
}

// 로그인된 사용자 정보 반환
function getUserData(){
	if(isset($_SESSION['userlogin'])){
		return $_SESSION['userlogin'];
	}else{
		return null;
	}

}



function session_set($sess_var = NULL, $sess_group = NULL){
	if($sess_group === NULL){
		$sess_group = 'hive';
	}

	if($sess_var !== NULL){
		foreach($sess_var as $key => $bar){
			$_SESSION[$sess_group][$key] = $bar;
		}
	}
}


function unsetAllSession($sess_group = NULL){

	if($sess_group){
		$_SESSION[$sess_group] = array();
		unset($_SESSION[$sess_group]);
	}
}



function encrypt($string, $key=SECRET_KEY) {
// 	$result = '';
// 	for($i=0; $i<strlen($string); $i++) {
// 		$char = substr($string, $i, 1);
// 		$keychar = substr($key, ($i % strlen($key))-1, 1);
// 		$char = chr(ord($char)+ord($keychar));
// 		$result .= $char;
// 	}
	$result = $string;
	return urlencode(base64_encode($result));
}

function decrypt($string, $key=SECRET_KEY) {
	$result = '';
	$string = base64_decode(urldecode($string));
	$result = $string;
// 	for($i=0; $i<strlen($string); $i++) {
// 		$char = substr($string, $i, 1);
// 		$keychar = substr($key, ($i % strlen($key))-1, 1);
// 		$char = chr(ord($char)-ord($keychar));
// 		$result .= $char;
// 	}
	return $result;
}





/**
 * 특정 자릿수 난수 발생
 * 영문 대문자 + 숫자만 사용 / 영문 대문자중 I, O 제외
 * @param
 * @return {string} rand_str
 * @exception
 */
function randomKey($length = 8) {
	
	$characters = 'ABCDEFGHJKLMNPQRSTUVWXYZ';
	$characters .= '0123456789'; 
	
	$key = '';
	$max = strlen($characters) - 1;
	for ($i = 0; $i < $length; $i++) {
		$key .= $characters[mt_rand(0, $max)];
	}
	
	return $key;
}

// 회사메일 인증용 숫자 난수
function company_email_key($length = 6) {

	//$characters = 'ABCDEFGHJKLMNPQRSTUVWXYZ';
	$characters = '123456789';

	$key = '';
	$max = strlen($characters) - 1;
	for ($i = 0; $i < $length; $i++) {
		$key .= $characters[mt_rand(0, $max)];
	}

	return $key;
}



/**
 * 이메일 인증용 코드 발급
 *
 * @param 
 * @return {string} auth_key 
 * @exception 
 */
function create_email_auth_key(){
	return strrev(base_convert(bin2hex(hash('sha512', uniqid(mt_rand() . microtime(true) * 10000, true), true)), 16, 36));;
}


/**
 * 이메일 전송
 *
 * @param {string} $toEmail 받는 사람 메일주소
 * @param {string} $subject 메일 제목
 * @param {string} $content 메일 내용
 * 
 * @return {bool}  
 * @exception
 */
function sendmail($toEmail, $subject, $content){
	$charset='UTF-8'; // 문자셋 : UTF-8
	
	$toName='email_auth'; // 받는이 이름
	$toEmail= $toEmail; // 받는이 이메일주소
	$fromName="MSABER"; // 보내는이 이름
	$fromEmail="serobmobile@gmail.com"; // 보내는이 이메일주소
	$body=$content; // 메일내용
	//$body = iconv('utf-8', 'euc-kr', $body);  //본문 내용 UTF-8화
	$encoded_subject="=?".$charset."?B?".base64_encode($subject)."?=\n"; // 인코딩된 제목
	$to= "\"=?".$charset."?B?".base64_encode($toName)."?=\" <".$toEmail.">" ; // 인코딩된 받는이
	$from= "\"=?".$charset."?B?".base64_encode($fromName)."?=\" <".$fromEmail.">" ; // 인코딩된 보내는이
	
	$headers="MIME-Version: 1.0\n".
			"Content-Type: text/html; charset=".$charset."; format=flowed\n".
			"To: ". $to ."\n".
			"From: ".$from."\n".
			"Return-Path: ".$from."\n".
			"Content-Transfer-Encoding: 8bit\n"; // 헤더 설정
	
	return mail( $to , $encoded_subject , $body , $headers );
}





function pagination($per_page, $page, $url = '', $total){
	$adjacents = "2";

	$page 	= ($page == 0 ? 1 : $page);
	$start 	= ($page - 1) * $per_page;

	$prev = $page - 1;
	$next = $page + 1;
	$lastpage = ceil($total/$per_page);
	$lpm1 = $lastpage - 1;

	$pagination = "";

	if($lastpage > 1)
	{
		$pagination = "<ul class='pagination'>";
		//$pagination .= "<li class='details'>Page $page of $lastpage</li>";
		if ($page > 1){

			$pagination.= "<li class='noborder'><a href='{$url}$prev'>&lt;</a></li>";
			// $pagination.= "<li><a href='{$url}$lastpage'>Last</a></li>";
		}else{
			//$pagination.= "<li><a class='current'>이전</a></li>";
			//$pagination.= "<li><a class='current'>Last</a></li>";
		}
		if ($lastpage < 7 + ($adjacents * 2))
		{
			for ($counter = 1; $counter <= $lastpage; $counter++)
			{
				if ($counter == $page){
					$pagination.= "<li class='active'><a class='current'>$counter</a></li>";
				}else{
					$pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
				}
			}
		}
		elseif($lastpage > 5 + ($adjacents * 2))
		{

			if($page < 1 + ($adjacents * 2))
			{
				for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
				{
					if ($counter == $page){
						$pagination.= "<li class='active'><a class='current'>$counter</a></li>";
					}else{
						$pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
					}
				}
				//$pagination.= "<li class='dot'>...</li>";
				$pagination.= "<li><a href='{$url}$lpm1'>$lpm1</a></li>";
				$pagination.= "<li><a href='{$url}$lastpage'>$lastpage</a></li>";
			}
			elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
			{
				$pagination.= "<li><a href='{$url}1'>1</a></li>";
				$pagination.= "<li><a href='{$url}2'>2</a></li>";
				//$pagination.= "<li class='dot'>...</li>";
				for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
				{
					if ($counter == $page)
						$pagination.= "<li class='active'><a class='current'>$counter</a></li>";
					else
						$pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
				}
				//$pagination.= "<li class='dot'>..</li>";
				$pagination.= "<li><a href='{$url}$lpm1'>$lpm1</a></li>";
				$pagination.= "<li><a href='{$url}$lastpage'>$lastpage</a></li>";
			}
			else
			{
				$pagination.= "<li><a href='{$url}1'>1</a></li>";
				$pagination.= "<li><a href='{$url}2'>2</a></li>";
				//$pagination.= "<li class='dot'>..</li>";
				for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
				{
					if ($counter == $page)
						$pagination.= "<li class='active'><a class='current'>$counter</a></li>";
					else
						$pagination.= "<li><a href='{$url}$counter'>$counter </a></li>";
				}
			}
		}


		if ($page < $counter - 1){
			$pagination.= "<li class='noborder'><a href='{$url}$next'>&gt;</a></li>";
			// $pagination.= "<li><a href='{$url}$lastpage'>Last</a></li>";
		}else{
			//$pagination.= "<li><a class='current'>이전</a></li>";
			// $pagination.= "<li><a class='current'>Last</a></li>";
		}
		$pagination.= "</ul>";
	}
	return $pagination;
}



function rsa_generate_keys($password, $bits = 2048, $digest_algorithm = 'sha256')
{
    $res = openssl_pkey_new(array(
        'digest_alg' => $digest_algorithm,
        'private_key_bits' => $bits,
        'private_key_type' => OPENSSL_KEYTYPE_RSA,
    ));
    
    openssl_pkey_export($res, $private_key, $password);
    
    $public_key = openssl_pkey_get_details($res);
    $public_key = $public_key['key'];
    
    return array(
        'private_key' => $private_key,
        'public_key' => $public_key,
    );
}

?>